
local function onmax(self,max)
	self.inst.maxtimepiont:set(max)
end
local function oncurrent(self,current)
	self.inst.currenttimepiont:set(current)
end

--
local kurumi_timepiont = Class(function(self, inst)
	self.inst = inst
	self.maxtimepiont = 500
	self.currenttimepiont = 100
end,
nil,
{
	maxtimepiont = onmax,
	currenttimepiont = oncurrent,
})

function kurumi_timepiont:DoDelta(delta)
	local val = self.currenttimepiont + delta
	if val >= self.maxtimepiont then
		self.currenttimepiont = self.maxtimepiont
	elseif val <= 0 then
		self.currenttimepiont = 0
	else
		self.currenttimepiont = val
	end
end

function kurumi_timepiont:GetPercent()
	return self.currenttimepiont/self.maxtimepiont
end

--浵
function kurumi_timepiont:OnSave()
	return 
	{
		currenttimepiont = self.currenttimepiont,
		maxtimepiont = self.maxtimepiont,
	}
end
function kurumi_timepiont:OnLoad(data)
    self.currenttimepiont = data.currenttimepiont
    self.maxtimepiont = data.maxtimepiont
end

return kurumi_timepiont